#pragma once
#include "stdafx.h"
#include "afxwin.h"

// PcanIsoTpExampleDlg.h : header file
//

// CPcanIsoTpExampleDlg dialog
class CPcanIsoTpExampleDlg : public CDialogEx
{
	// Construction
public:
	CPcanIsoTpExampleDlg(CWnd* pParent = NULL);	// standard constructor
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
#ifdef AFX_DESIGN_TIME
	enum { IDD = IDD_PCANISOTPEXAMPLE_DIALOG };
#endif

public_member:
	CPCanIsoTpExampleDlgMessages *m_dlgMessages; // Handle on tab Messages
	CPCanIsoTpExampleDlgMappings *m_dlgMappings; // Handle on tab Mappings
	CPCanIsoTpExampleDlgParameters *m_dlgParameters; // Handle on tab Parameters
	CPCanIsoTpExampleTabCtrl *m_TabCtrl; // Handle on Class TabCtrl which contains and create the 3 tabs

										 //Baudrates
	const std::vector<TPCANTPBaudrate> m_pctpBaudrates{ PCANTP_BAUD_1M,   PCANTP_BAUD_800K, PCANTP_BAUD_500K, PCANTP_BAUD_250K,
														PCANTP_BAUD_125K, PCANTP_BAUD_47K,  PCANTP_BAUD_100K, PCANTP_BAUD_50K, 
														PCANTP_BAUD_20K,  PCANTP_BAUD_10K,  PCANTP_BAUD_5K,   PCANTP_BAUD_83K,
														PCANTP_BAUD_33K,  PCANTP_BAUD_95K };
	//HardwareType
	std::vector<std::pair<TPCANTPHWType, CString>> m_pctpHWType{ { PCANTP_TYPE_ISA,		    L"PCANTP_TYPE_ISA" },	     { PCANTP_TYPE_ISA_SJA, L"PCANTP_TYPE_ISA_SJA" },
																 { PCANTP_TYPE_ISA_PHYTEC,  L"PCANTP_TYPE_ISA_PHYTEC" }, { PCANTP_TYPE_DNG,     L"PCANTP_TYPE_DNG" },
																 { PCANTP_TYPE_DNG_EPP,     L"PCANTP_TYPE_DNG_EPP" },	 { PCANTP_TYPE_DNG_SJA, L"PCANTP_TYPE_DNG_SJA" },
																 { PCANTP_TYPE_DNG_SJA_EPP, L"PCANTP_TYPE_DNG_SJA_EPP" } };

	//IoPort
	const std::vector<CString> m_pctIoPort{ L"0100", L"0120", L"0140", L"0200", L"0220", L"0240", L"0260", L"0278", L"0280", L"02A0", L"02C0", L"02E0",
											L"02E8", L"02F8", L"0300", L"0320", L"0340", L"0360", L"0378", L"0380", L"03BC", L"03E0", L"03E8", L"03F8" };

	//Interrupt
	const std::vector<CString> m_pctInterrupt{ L"3", L"4", L"5", L"7", L"9", L"10", L"11", L"12", L"15" };

	// Creates an array with all possible PCAN-ISO-TP Channels.
	const std::vector<std::pair<TPCANTPHandle, CString>> m_pctpHandles{ { PCANTP_ISABUS1,  L"PCAN_ISA 1" }, { PCANTP_ISABUS2,  L"PCAN_ISA 2" }, { PCANTP_ISABUS3,  L"PCAN_ISA 3" },
																		{ PCANTP_ISABUS4,  L"PCAN_ISA 4" }, { PCANTP_ISABUS5,  L"PCAN_ISA 5" }, { PCANTP_ISABUS6,  L"PCAN_ISA 6" },
																		{ PCANTP_ISABUS7,  L"PCAN_ISA 7" }, { PCANTP_ISABUS8,  L"PCAN_ISA 8" }, { PCANTP_DNGBUS1,  L"PCAN_DNG 1" },
																		{ PCANTP_PCIBUS1,  L"PCAN_PCI 1" }, { PCANTP_PCIBUS2,  L"PCAN_PCI 2" }, { PCANTP_PCIBUS3,  L"PCAN_PCI 3" },
																		{ PCANTP_PCIBUS4,  L"PCAN_PCI 4" }, { PCANTP_PCIBUS5,  L"PCAN_PCI 5" }, { PCANTP_PCIBUS6,  L"PCAN_PCI 6" },
																		{ PCANTP_PCIBUS7,  L"PCAN_PCI 7" }, { PCANTP_PCIBUS8,  L"PCAN_PCI 8" }, { PCANTP_PCIBUS9,  L"PCAN_PCI 9" },
																		{ PCANTP_PCIBUS10, L"PCAN_PCI 10" },{ PCANTP_PCIBUS11, L"PCAN_PCI 11" },{ PCANTP_PCIBUS12, L"PCAN_PCI 12" },
																		{ PCANTP_PCIBUS13, L"PCAN_PCI 13" },{ PCANTP_PCIBUS14, L"PCAN_PCI 14" },{ PCANTP_PCIBUS15, L"PCAN_PCI 15" },
																		{ PCANTP_PCIBUS16, L"PCAN_PCI 16" },{ PCANTP_USBBUS1,  L"PCAN_USB 1" }, { PCANTP_USBBUS2,  L"PCAN_USB 2" },
																		{ PCANTP_USBBUS3,  L"PCAN_USB 3" }, { PCANTP_USBBUS4,  L"PCAN_USB 4" }, { PCANTP_USBBUS5,  L"PCAN_USB 5" },
																		{ PCANTP_USBBUS6,  L"PCAN_USB 6" }, { PCANTP_USBBUS7,  L"PCAN_USB 7" }, { PCANTP_USBBUS8,  L"PCAN_USB 8" },
																		{ PCANTP_USBBUS9,  L"PCAN_USB 9" }, { PCANTP_USBBUS10, L"PCAN_USB 10" },{ PCANTP_USBBUS11, L"PCAN_USB 11" },
																		{ PCANTP_USBBUS12, L"PCAN_USB 12" },{ PCANTP_USBBUS13, L"PCAN_USB 13" },{ PCANTP_USBBUS14, L"PCAN_USB 14" },
																		{ PCANTP_USBBUS15, L"PCAN_USB 15" },{ PCANTP_USBBUS16, L"PCAN_USB 16" },{ PCANTP_PCCBUS1,  L"PCAN_PCC 1" },
																		{ PCANTP_PCCBUS2,  L"PCAN_PCC 2" }, { PCANTP_LANBUS1,  L"PCAN_LAN 1" }, { PCANTP_LANBUS2,  L"PCAN_LAN 2" },
																		{ PCANTP_LANBUS3,  L"PCAN_LAN 3" }, { PCANTP_LANBUS4,  L"PCAN_LAN 4" }, { PCANTP_LANBUS5,  L"PCAN_LAN 5" },
																		{ PCANTP_LANBUS6,  L"PCAN_LAN 6" }, { PCANTP_LANBUS7,  L"PCAN_LAN 7" } ,{ PCANTP_LANBUS8,  L"PCAN_LAN 8" },
																		{ PCANTP_LANBUS9,  L"PCAN_LAN 9" }, { PCANTP_LANBUS10, L"PCAN_LAN 10" },{ PCANTP_LANBUS11, L"PCAN_LAN 11" },
																		{ PCANTP_LANBUS12, L"PCAN_LAN 12" },{ PCANTP_LANBUS13, L"PCAN_LAN 13" },{ PCANTP_LANBUS14, L"PCAN_LAN 14" },
																		{ PCANTP_LANBUS15, L"PCAN_LAN 15" },{ PCANTP_LANBUS16, L"PCAN_LAN 16" } };
	TPCANTPBaudrate m_baudrate; // Baudrate selected on combobox Channel
	TPCANTPHandle m_pctpHandle; // Handle selected on combobox Channel
	TPCANTPHWType m_hwType = 0;
	UINT32 m_ioPort = 0;
	BYTE m_interrupt = 0;
	CString m_textCanFd = L""; // Bit rate text
	bool m_bCanFdSupport = false;

public_method:
	void InitializeUiConnection();
	void InitializeUiTabParameters();
	void SetConnectionStatus(bool p_bConnected);
	bool Connect(TPCANTPHandle p_canHandle, TPCANTPBaudrate p_baudrate, TPCANTPHWType p_hwType, UINT32 p_ioPort, byte p_interrupt);
	bool Disconnect();
	bool isConnected();

protected_method:
	// Generated message map functions
	DECLARE_MESSAGE_MAP()
	virtual BOOL OnInitDialog();
	virtual BOOL DestroyWindow();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnPaint();
	afx_msg void OnBnClickedButtonRefresh();
	afx_msg void OnBnClickedButtonInit();
	afx_msg void OnCbnSelchangeComboChannel();
	afx_msg void OnCbnSelchangeComboBaudrate();
	afx_msg void OnClose();
	afx_msg void OnCbnSelchangeComboHwtype();
	afx_msg void OnCbnSelchangeComboIoport();
	afx_msg void OnCbnSelchangeComboInterrupt();
	afx_msg void OnBnClickedButtonRelease();
	afx_msg void OnBnClickedCheckFd();
	afx_msg void OnEnChangeEditFd();

protected_properties:
// Dialog Data
	HICON m_hIcon;
	CButton buttonInit;
	CButton buttonHwRefresh;
	CButton buttonRelease;
	CComboBox comboBoxBaudrate;
	CComboBox comboBoxHwType;
	CComboBox comboBoxIoPort;
	CComboBox comboBoxInterrupt;
	CComboBox comboBoxChannel;
	CButton checkBoxCanFd;
	CEdit textBoxCanFdBitrate;
	CStatic labelBaudrate;
	CStatic labelHardwareType;
	CStatic labelIOPort;
	CStatic labelBitrate;
	CStatic labelInterrupt;
};
